<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class RemainingNotificationParameter extends Model 
{

    protected $table = 'remaining_notification_parameters';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('scdp_delay_day', 'critic_limit', 'service_station_id');
    protected $visible = array('scdp_delay_day', 'critic_limit', 'service_station_id');

    public function service_station()
    {
        return $this->belongsTo('ServiceStation', 'service_station_id');
    }

}